% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter_int}
\alias{filter_int}
\title{Filter by (relative) peak magnitude}
\usage{
filter_int(mfd, norm_int_min = NULL, norm_int_max = NULL, verbose = FALSE, ...)
}
\arguments{
\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{norm_int_min}{Lower threshold (>=) of (normalized) peak magnitude}

\item{norm_int_max}{Upper threshold (<=) of (normalized) peak magnitude}

\item{verbose}{logical; if \code{TRUE}, show progress messages.}

\item{...}{
  Arguments passed on to \code{\link[=calc_norm_int]{calc_norm_int}}
  \describe{
    \item{\code{ms_id}}{Character; name of the column identifying individual spectra (default: \code{"file_id"}).}
    \item{\code{peak_id}}{Character; name of the column identifying unique peaks (default: \code{"peak_id"}).}
    \item{\code{peak_magnitude}}{Character; name of the column containing peak intensity values (default: \code{"i_magnitude"}).}
    \item{\code{normalization}}{Character; normalization method to apply. One of \code{"bp"}, \code{"sum"}, \code{"sum_ubiq"}, \code{"sum_rank"}, \code{"none"}. Default is \code{"bp"}.}
    \item{\code{n_rank}}{Integer; number of top-ranked peaks to use for \code{"sum_rank"} normalization (default: 200).}
  }}
}
\value{
data.table; subset of original molecular formula table
}
\description{
This function filters molecular formulas by (relative) peak abundances.
}
\examples{
filter_int(mfd = calc_norm_int(mfd = mf_data_demo,
normalization = "sum_rank", n_rank = 100), norm_int_min = 1)
}
\seealso{
Other Formula subsetting: 
\code{\link{filter_mass_accuracy}()},
\code{\link{filter_mf_data}()},
\code{\link{remove_blanks}()},
\code{\link{subset_known_mf}()},
\code{\link{ume_assign_formulas}()},
\code{\link{ume_filter_formulas}()}
}
\concept{Formula subsetting}
\keyword{misc}
