% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uplot_kmd.R
\name{uplot_kmd}
\alias{uplot_kmd}
\title{Kendrick Mass Defect (KMD) vs. Nominal Mass Plot}
\usage{
uplot_kmd(
  df,
  z_var = "norm_int",
  palname = "redblue",
  size_dots = 0.5,
  col_bar = TRUE,
  tf = FALSE,
  logo = TRUE,
  cex.axis = 12,
  cex.lab = 15,
  plotly = FALSE,
  ...
)
}
\arguments{
\item{df}{A \code{data.table} or \code{data.frame} containing columns:
\itemize{
\item \code{nm}  (nominal mass)
\item \code{kmd} (Kendrick mass defect)
\item the color variable given in \code{z_var}.
}}

\item{z_var}{Character. Name of the column used for color mapping.}

\item{palname}{Character. Palette name passed to \code{f_colorz()}.}

\item{size_dots}{Numeric. Point size.}

\item{col_bar}{Logical. (Reserved for future use; currently ignored.)}

\item{tf}{Logical. (Reserved for future use; currently passed to \code{f_colorz()} via \code{...} if desired.)}

\item{logo}{Logical. If TRUE, adds a UME caption.}

\item{cex.axis}{Numeric. Axis text size.}

\item{cex.lab}{Numeric. Axis label size.}

\item{plotly}{Logical. If TRUE, return interactive plotly object.}

\item{...}{
  Arguments passed on to \code{\link[=f_colorz]{f_colorz}}
  \describe{
    \item{\code{z}}{Numeric vector. Values whose colors should be computed.}
    \item{\code{col_num}}{Integer. Number of colors in the palette (default: \code{100}).}
    \item{\code{verbose}}{logical; if \code{TRUE}, show progress messages.}
  }}
}
\value{
A \code{ggplot} object (or a \code{plotly} object if \code{plotly = TRUE})
showing KMD vs nominal mass.
}
\description{
This function generates a scatter plot of Kendrick Mass Defect (KMD) versus
nominal mass (\code{nm}), with color-coding based on a specified variable
(\code{z_var}). Optionally, the plot can be returned as an interactive Plotly
object.
}
\details{
Kendrick Mass Defect (KMD) vs. Nominal Mass Plot
}
\examples{
uplot_kmd(mf_data_demo, z_var = "norm_int", plotly = TRUE)

}
\references{
Kendrick E. (1963). A mass scale based on CH\eqn{_2} = 14.0000 for high
resolution mass spectrometry of organic compounds.
\emph{Analytical Chemistry}, \strong{35}, 2146–2154.

Hughey C.A., Hendrickson C.L., Rodgers R.P., Marshall A.G., Qian K.N. (2001).
Kendrick mass defect spectrum: A compact visual analysis for ultrahigh-resolution
broadband mass spectra. \emph{Analytical Chemistry}, \strong{73}, 4676–4681.
\doi{10.1021/ac010560w}
}
\seealso{
Other plots: 
\code{\link{uplot_cluster}()},
\code{\link{uplot_cvm}()},
\code{\link{uplot_dbe_minus_o_freq}()},
\code{\link{uplot_dbe_vs_c}()},
\code{\link{uplot_freq_ma}()},
\code{\link{uplot_freq_vs_ppm}()},
\code{\link{uplot_hc_vs_m}()},
\code{\link{uplot_heteroatoms}()},
\code{\link{uplot_isotope_precision}()},
\code{\link{uplot_lcms}()},
\code{\link{uplot_ma_vs_mz}()},
\code{\link{uplot_ms}()},
\code{\link{uplot_n_mf_per_sample}()},
\code{\link{uplot_pca}()},
\code{\link{uplot_ratios}()},
\code{\link{uplot_reproducibility}()},
\code{\link{uplot_ri_vs_sample}()},
\code{\link{uplot_vk}()}
}
\concept{plots}
