% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{AmpliconPlot}
\alias{AmpliconPlot}
\title{Generate Amplicon plots}
\usage{
AmpliconPlot(
  object,
  filter.name = "default",
  cut.off = 5,
  min.count = 0,
  min.vaf = 0,
  amplicons = NULL,
  samples = NULL,
  abs.count = FALSE,
  y_min = 0,
  y_max = NULL,
  theme = "classic",
  option = "default",
  direction = "default",
  plot.text = FALSE,
  plot.ref = TRUE,
  stack.plot = FALSE,
  classic.plot = FALSE,
  fdr = 0.05,
  font.size = 6,
  angle = 45,
  use.caller = FALSE,
  use.plotly = TRUE
)
}
\arguments{
\item{object}{Requires a UMI sample or UMI experiment object}

\item{filter.name}{Name of the filter to be plotted.}

\item{cut.off}{How many variant reads are necessary to consider a variant above background? Default is 5 reads.}

\item{min.count}{Minimum variants counts to plot, default is 0.}

\item{min.vaf}{Minimum variants allele frequency to plot, default is 0.}

\item{amplicons}{(Optional) character vector of amplicons to be plotted.}

\item{samples}{(Optional) character vector of samples to be plotted.}

\item{abs.count}{Should absolute counts be plotted instead of frequencies? Default is FALSE.}

\item{y_min}{Minimum y-axis value, default is 0}

\item{y_max}{Maximum y-axis value, default is NULL (autoscale)}

\item{theme}{Plotting theme to use, default is classic.}

\item{option}{Color palette to use.}

\item{direction}{Orientation of the color palette.}

\item{plot.text}{Should non-references bases be indicated above the bar?}

\item{plot.ref}{If true show reference base instead of position on x-axis.}

\item{stack.plot}{Show all variant alleles in a stacked bar plot.}

\item{classic.plot}{Show classical debarcer amplicon plot with raw error.}

\item{fdr}{False-discovery-rate cut-off for variants.}

\item{font.size}{Font size}

\item{angle}{Font angle}

\item{use.caller}{Should data from variant caller be used? Default is FALSE}

\item{use.plotly}{Should plotly be used instead of the regular ggplot device? Default is TRUE}
}
\value{
A UMIexperiment object containing a ggplot object with the
amplicon plot.
}
\description{
Plots variant allele frequencies or alternate allele counts for chosen
samples and assays.
}
\examples{
library(umiAnalyzer)

main = system.file('extdata', package = 'umiAnalyzer')
samples <- list.dirs(path = main, full.names = FALSE, recursive = FALSE)
simsen <- createUmiExperiment(experimentName = 'example',mainDir = main,sampleNames = samples)
simsen <- filterUmiObject(simsen)

amplicon_plot <- AmpliconPlot(simsen)


}
