% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variant_caller.R
\name{callVariants}
\alias{callVariants}
\title{callVariants using beta binomial distribution}
\usage{
callVariants(object, minDepth = 3, minCoverage = 100, computePrior = FALSE)
}
\arguments{
\item{object}{A UMIErrorCorrect object.}

\item{minDepth}{Minimum consensus depth required default is 3}

\item{minCoverage}{Minimum Coverage to use, default is 100 reads.}

\item{computePrior}{Should a new distribution be derived from data? Default is FALSE.}
}
\value{
Object containing raw and FDR-adjusted P-Values
}
\description{
Calculate variant p-values using permutation-based testing. A prior is fitted
to model the background error using maximum likelihood estimation of a beta
distribution. The maximum likelihood estimate of the beta distribution is then
used to define the shape of a beta-binomial distribution used to estimate
variant P-Values. This can be interpreted as a probability for a variant to
not have arisen by chance.
}
\examples{
library(umiAnalyzer)
main <- system.file("extdata", package = "umiAnalyzer")

simsen <- createUmiExperiment(main)
simsen <- filterUmiObject(simsen)
simsen <- callVariants(simsen, computePrior = FALSE)

}
\seealso{
\code{\link{filterVariants}} on how to filter variants.
}
