% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restore.R
\name{fix_serial_columns}
\alias{fix_serial_columns}
\title{Fix likely-serial columns in a data frame}
\usage{
fix_serial_columns(
  df,
  pmin = 0.8,
  low_serial = 20000,
  high_serial = 65000,
  year_window = 1990:2035,
  origin_mode = "auto",
  ref_date = Sys.Date()
)
}
\arguments{
\item{df}{A data frame.}

\item{pmin}{Minimum fraction of in-range integers to flag a column.}

\item{low_serial}{Lower bound for plausible serials (inclusive).}

\item{high_serial}{Upper bound for plausible serials (inclusive).}

\item{year_window}{Integer vector of years that, when resolved, will be
considered valid to revert. This guards against accidental matches.}

\item{origin_mode}{One of "auto", "1900", or "1904". In "1900" mode the
origin is "1899-12-30" (Excel’s 1900 system with the leap-year quirk
compensated). In "1904" mode the origin is "1904-01-01". In "auto" mode,
the origin yielding dates with median proximity to a reference date is
chosen; the reference can be controlled via \code{ref_date} for tests.}

\item{ref_date}{Reference date for origin selection when origin_mode="auto".
Defaults to Sys.Date(); set to a fixed Date in tests for determinism.}
}
\value{
The data frame with corrected columns where applicable.
}
\description{
Applies \code{restore_day_month()} only to columns that look dominated by
Excel serials, controlled by a minimum fraction threshold.
}
\examples{
df <- data.frame(a = c(45812, 44730), b = c(1.2, 3.4))
fix_serial_columns(df)
}
