% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Limerick.R
\docType{data}
\name{limerick_2}
\alias{limerick_2}
\title{Secondary colors of the University of Limerick, Ireland}
\format{
An object of class \code{character} of length 17.
}
\source{
Colour definitions are based on \href{https://www.ul.ie}{ULimerick}'s 
\href{https://www.ul.ie/media/31805/download?inline}{brand guidelines} (PDF).
}
\usage{
limerick_2
}
\value{
A names vector of colors (HEX/HTML codes of type character).
}
\description{
\code{limerick_2} provides the twelve secondary colors
of the \href{https://www.ul.ie}{University of Limerick}, Ireland.
}
\details{
The 12 secondary colors are
\code{"shannon"} (defined as HEX #00A3E0),
\code{"sky"} (defined as HEX #007DBA),
\code{"stone"} (defined as HEX #2D5980),
\code{"marine"} (defined as HEX #13294B), 
\code{"marigold"} (defined as HEX #FFC72C), 
\code{"golden leaf"} (defined as HEX #FFA300), 
\code{"pumpkin"} (defined as HEX #D45D00), 
\code{"munster"} (defined as HEX #CB333B), 
\code{"salmon"} (defined as HEX #E31C79), 
\code{"autumnal leaf"} (defined as HEX #6F263D), 
\code{"copper"} (defined as HEX #89532F), 
\code{"bronze"} (defined as HEX #7e5c4d), 
\code{"white"} (defined as HEX #FFFFFF), 
\code{"limestone"} (defined as HEX #919D9D), 
\code{"pebble"} (defined as HEX #707372), 
\code{"granite"} (defined as HEX #505759), and 
\code{"slate"} (defined as HEX #373A36). 

\code{limerick_2} uses the HEX color definitions.
}
\examples{
limerick_2
unikn::seecol(limerick_2, col_bg = "grey90",  
              main = "Secondary colours of the University of Limerick") # view palette

}
\seealso{
\code{\link{limerick_2}} for primary colours of the University of Limerick; 
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other Irish university color palettes: 
\code{\link{galway_1}},
\code{\link{galway_2}},
\code{\link{limerick_1}},
\code{\link{maynooth}},
\code{\link{trinity_1}},
\code{\link{trinity_2}},
\code{\link{ucc_1}},
\code{\link{ucc_2}},
\code{\link{ucd}}
}
\author{
\strong{unicol}, 2320-07-16.
}
\concept{Irish university color palettes}
\keyword{datasets}
