% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unitedSim.R
\name{unitedSim}
\alias{unitedSim}
\title{Simulating a formation}
\usage{
unitedSim(
  home,
  ...,
  r,
  penaltyProb = 0.1,
  preventGoalGK = 1/14,
  preventGoalSW = 1/15,
  hardnessMatrix,
  L,
  overtime = FALSE
)
}
\arguments{
\item{home}{home team (an object of the \code{S4}class \code{formation})}

\item{...}{several objects of the class \code{formation}}

\item{r}{number of replications for the simulation of hardness and penalties, can 
be \code{missing} (exact results will be computed)}

\item{penaltyProb}{occurrence probability of a penalty}

\item{preventGoalGK}{factor multiplicied with the strength of the GK for computing the 
probability of preventing a goal by the goalkeeper}

\item{preventGoalSW}{factor multiplicied with the strength of the SW for computing the 
probability of preventing a goal by the sweeper}

\item{hardnessMatrix}{\code{matrix} matrix with eleven columns which contain the probability 
for yellow cards dependent on the used hardness}

\item{L}{\code{list} with elements of class \code{formation}}

\item{overtime}{\code{logical}, if True overtime win probabilites are calculated. Only
available if total hardness is zero or one.}
}
\value{
Creates an object of the \code{unitedSim} class.
}
\description{
Simulates a formation against another formations (several formations of away are possible).
}
\examples{
home <- formation(10, NA, c(7,5,3), c(8,8), c(10,10,8))
away <- formation(5, 8, c(8,8), c(10,10), c(10,10,10),
 hardness = c(0,0,0,0,1))
set.seed(123)
unitedSim(home, away)
# can also be simualated
unitedSim(home, away, r = 100)
# several away lineups
unitedSim(home, away, away)
# several away lineups simulated
unitedSim(home, away, away, r = 100)
# used hardness matrix (default)
# shows the probability of receiving a specifed number of yellow cards
# dependent on the used points of hardness
dimNams <-  list(paste(0:7, "cards"), paste(0:10, "hardness points"))
(hardnessMatrix <- matrix(c(90,10,0,0,0,0,0,0,
70,30,0,0,0,0,0,0,50,40,10,
0,0,0,0,0,30,50,20,0,0,0,0,0,20,40,30,10,0,0,
0,0,10,30,40,20,0,0,0,0,0,20,40,30,10,0,0,0,0,
10,30,40,20,0,0,0,0,0,20,40,30,10,0,0,0,0,10,20,
40,20,10,0,0,0,0,10,40,20,20,10), nrow = 8,
dimnames = dimNams))


}
\seealso{
\code{\link{unitedSimOne}}
}
