% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance.R
\name{closure_gauge_complexity}
\alias{closure_gauge_complexity}
\title{Heuristic to predict CLOSURE runtime}
\usage{
closure_gauge_complexity(mean, sd, n, scale_min, scale_max)
}
\arguments{
\item{mean}{String (length 1). Reported mean.}

\item{sd}{String (length 1). Reported sample standard deviation.}

\item{n}{Numeric (length 1). Reported sample size.}

\item{scale_min, scale_max}{Numeric (length 1 each). Minimal and maximal
possible values of the measurement scale. For example, with a 1-7 Likert
scale, use \code{scale_min = 1} and \code{scale_max = 7}. Prefer the empirical min
and max if available: they constrain the possible values further.}
}
\value{
Numeric (length 1).
}
\description{
Before you run \code{\link[=closure_generate]{closure_generate()}}, you may want to get a
sense of the time it will take to run. Use \code{closure_gauge_complexity()} to
compute a heuristics-based complexity score. For reference, here is how it
determines the messages in \code{closure_generate()}:

\tabular{ll}{
\strong{Value} \tab \strong{Message} \cr
if < 1       \tab (no message)                 \cr
else if < 2  \tab "Just a second..."           \cr
else if < 3  \tab "This could take a minute..."\cr
else         \tab "NOTE: Long runtime ahead!"
}
}
\details{
The result of this function is hard to interpret. All it can do is
to convey an idea about the likely runtime of CLOSURE. This is because the
input parameters interact in highly dynamic ways, which makes prediction
difficult.

In addition, even progress bars or updates at regular intervals (e.g., "10\%
complete") prove to be extremely challenging: the Rust code computes
CLOSURE results in parallel, which makes it hard to get an overview of the
total progress across all cores; and especially to display such information
on the R level.
}
\examples{
# Low SD, N, and scale range:
closure_gauge_complexity(
  mean = 2.55,
  sd = 0.85,
  n = 84,
  scale_min = 1,
  scale_max = 5
)

# Somewhat higher:
closure_gauge_complexity(
  mean = 4.26,
  sd = 1.58,
  n = 100,
  scale_min = 1,
  scale_max = 7
)

# Very high:
closure_gauge_complexity(
  mean = 3.81,
  sd = 3.09,
  n = 156,
  scale_min = 1,
  scale_max = 7
)
}
