% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updog.R
\docType{package}
\name{updog-package}
\alias{updog}
\alias{updog-package}
\title{updog: Flexible Genotyping for Polyploids}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Implements empirical Bayes approaches to genotype polyploids from next generation sequencing data while accounting for allele bias, overdispersion, and sequencing error. The main functions are flexdog() and multidog(), which allow the specification of many different genotype distributions. Also provided are functions to simulate genotypes, rgeno(), and read-counts, rflexdog(), as well as functions to calculate oracle genotyping error rates, oracle_mis(), and correlation with the true genotypes, oracle_cor(). These latter two functions are useful for read depth calculations. Run browseVignettes(package = "updog") in R for example usage. See Gerard et al. (2018) \doi{10.1534/genetics.118.301468} and Gerard and Ferrao (2020) \doi{10.1093/bioinformatics/btz852} for details on the implemented methods.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://dcgerard.github.io/updog/}
  \item Report bugs at \url{https://github.com/dcgerard/updog/issues}
}

}
\author{
\strong{Maintainer}: David Gerard \email{gerard.1787@gmail.com} (\href{https://orcid.org/0000-0001-9450-5023}{ORCID})

}
\keyword{internal}
