% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{house_tbl_df}
\alias{house_tbl_df}
\title{United States House of Representatives historical make-up}
\format{
A tibble with 116 observations and 12 variables:
\describe{
  \item{congress}{Congress number (numeric).}
  \item{year_start}{Starting year of the congress (numeric).}
  \item{year_end}{Ending year of the congress (numeric).}
  \item{seats}{Total number of seats in the House of Representatives (numeric).}
  \item{p1}{Abbreviation of the first party (character).}
  \item{np1}{Number of seats for the first party (numeric).}
  \item{p2}{Abbreviation of the second party (character).}
  \item{np2}{Number of seats for the second party (numeric).}
  \item{other}{Number of seats for other parties (numeric).}
  \item{vac}{Number of vacant seats (numeric).}
  \item{del}{Number of delegate seats (numeric).}
  \item{res}{Number of resident commissioner seats (numeric).}
}
}
\source{
Historical House of Representatives Data
}
\usage{
data(house_tbl_df)
}
\description{
The dataset name has been changed to 'house_tbl_df' to avoid confusion with other packages in
the R ecosystem from which datasets have been sourced. This naming convention helps distinguish
this dataset as part of the 'usdatasets' package and assists users in identifying its specific
characteristics. The suffix 'tbl_df' identifies the dataset as a tibble. The original content
of the dataset has not been modified in any way.
}
