% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confirm_overlap.R, R/confirm_overlap_helpers.R
\name{confirm_overlap}
\alias{confirm_overlap}
\alias{co_find_only_in_1}
\alias{co_find_only_in_2}
\alias{co_find_in_both}
\title{Confirm Overlap}
\usage{
confirm_overlap(vec1, vec2, return_tibble = F)

co_find_only_in_1(co_output)

co_find_only_in_2(co_output)

co_find_in_both(co_output)
}
\arguments{
\item{vec1}{vector 1}

\item{vec2}{vector 2}

\item{return_tibble}{logical. If TRUE, returns  a tibble. otherwise by default returns the database invisibly to be queried by helper functions.}

\item{co_output}{dataframe output from confirm_overlap}
}
\value{
tibble. overlap summary or overlap table
}
\description{
Prints a venn-diagram style summary of the unique value
overlap between two columns and also invisibly returns a dataframe that can be assigned to a variable
and queried with the overlap helpers. The helpers can return values that appeared only the first col, second col,
or both cols.
}
\examples{

confirm_overlap(iris$Sepal.Width, iris$Sepal.Length) -> iris_overlap

iris_overlap

iris_overlap \%>\%
co_find_only_in_1()

iris_overlap \%>\%
co_find_only_in_2()

iris_overlap \%>\%
co_find_in_both()
}
