% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sendTasks.R
\name{sendTasks}
\alias{sendTasks}
\title{Send prepared task to Mturk and record the API-returned HIT ids.}
\usage{
sendTasks(
  hit_type = NULL,
  hit_layout = NULL,
  type = NULL,
  tasksrecord = NULL,
  tasksids = NULL,
  HITidspath = NULL,
  n_assignments = "1",
  expire_in_seconds = as.character(60 * 60 * 8),
  batch_annotation = NULL
)
}
\arguments{
\item{hit_type}{find from the Mturk requester's dashboard}

\item{hit_layout}{find from the Mturk requester's dashboard}

\item{type}{one of WI, T8WSI, R4WSI}

\item{tasksrecord}{output of recordTasks()}

\item{tasksids}{ids of tasks to send in numeric form. If left unspecified, the whole batch will be posted}

\item{HITidspath}{path to record the returned HITids}

\item{n_assignments}{number of of assignments per task. For the validation tasks, people almost always want 1}

\item{expire_in_seconds}{default 8 hours}

\item{batch_annotation}{add if needed}
}
\value{
A list containing two elements:
\itemize{
\item{current_HIT_ids:}{A vector of the HIT IDs returned by the API.}}
\itemize{
\item{map_ids:}{A data frame that maps the tasksids to their corresponding HIT ids.}
}
}
\description{
Send prepared task to Mturk and record the API-returned HIT ids.
}
\details{
Pairs the local ids with Mturk ids and save them to specified paths
}
