% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na_check.R
\name{write_na_check}
\alias{write_na_check}
\alias{suggest_na_check}
\title{Suggest a check for completeness.}
\usage{
write_na_check(d, vars = names(d), file = stdout())

suggest_na_check(d, vars = names(d))
}
\arguments{
\item{d}{\code{data.frame}, used to generate the checks}

\item{vars}{\code{character} optionally the subset of variables to be used.}

\item{file}{file to which the checks will be written to.}
}
\value{
\code{suggest_na_check} returns \code{\link[validate:validator]{validate::validator()}} object with the suggested rules.
\code{write_na_check} write the rules to file and returns invisibly a named list of ranges for each variable.
}
\description{
Suggest a check for completeness.
}
\examples{
data(retailers, package="validate")

# will generate check for all columns in retailers that are
# complete.
suggest_na_check(retailers)
}
