% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls_analysis.R
\name{fit_pls_multivariate}
\alias{fit_pls_multivariate}
\title{Fit PLS Regression with Cross-Validation Component Selection}
\usage{
fit_pls_multivariate(
  X_matrix,
  Y_matrix,
  max_components = NULL,
  cv_segments = 10L,
  scale = TRUE,
  center = TRUE
)
}
\arguments{
\item{X_matrix}{Numeric matrix of predictor variables (direct prices).}

\item{Y_matrix}{Numeric matrix of response variables (production prices).}

\item{max_components}{Maximum number of components to consider.
Default NULL uses min(ncol(X), nrow(X)-1, ncol(Y), 25).}

\item{cv_segments}{Number of cross-validation segments. Default 10.}

\item{scale}{Logical. Scale variables before fitting. Default TRUE.}

\item{center}{Logical. Center variables before fitting. Default TRUE.}
}
\value{
A list containing:
\describe{
  \item{model}{The fitted pls model object}
  \item{optimal_ncomp}{Optimal number of components by CV-RMSE}
  \item{cv_table}{Data frame with CV metrics by number of components}
  \item{metrics_cv}{CV metrics at optimal component number}
  \item{metrics_insample}{In-sample metrics at optimal component number}
}
}
\description{
Fits a partial least squares regression model with automatic selection
of the optimal number of components via cross-validation.
}
\details{
This function uses the pls package for PLS regression. Component
selection is based on minimizing cross-validated RMSE. The function
handles log-transformed data and reports metrics in both log and
original scales.
}
\examples{
\donttest{
if (requireNamespace("pls", quietly = TRUE)) {
  set.seed(123)
  n <- 50
  p <- 10
  X <- matrix(rnorm(n * p), n, p)
  colnames(X) <- paste0("X", 1:p)
  Y <- X[, 1:3] \%*\% diag(c(1, 0.5, 0.3)) + matrix(rnorm(n * 3, 0, 0.5), n, 3)
  colnames(Y) <- paste0("Y", 1:3)

  result <- fit_pls_multivariate(X, Y, max_components = 8)
  print(result$optimal_ncomp)
  print(result$cv_table)
}
}

}
