% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_gen.R
\name{varband_gen}
\alias{varband_gen}
\title{Generate a model with variable bandwidth.}
\usage{
varband_gen(p, block = 10)
}
\arguments{
\item{p}{the dimension of L}

\item{block}{the number of block diagonal structures in the resulting model, assumed to divide p}
}
\value{
a p-by-p lower triangular matrix with variable bandwidth
}
\description{
Generate lower triangular matrix with variable bandwidth. See, e.g., Model 2 and 3 in the paper.
}
\examples{
set.seed(123)
# small block size (big number of blocks)
true_small <- varband_gen(p = 50, block = 10)
# large block size (small number of blocks)
true_large <- varband_gen(p = 50, block = 2)
}

