% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{integration}
\alias{integration}
\title{Computes integration and acontamination of the clustering}
\usage{
integration(group, true_group)
}
\arguments{
\item{group}{A vector, first partition.}

\item{true_group}{A vector, second (reference) partition.}
}
\value{
An array containing values of integration and acontamination.
}
\description{
Integartion and acontamination are measures of the quality of a clustering 
with a reference to a true partition. Let \eqn{X = (x_1, \ldots x_p)} be the 
data set, \eqn{A} be a partition into clusters \eqn{A_1, \ldots A_n} (true 
partition) and \eqn{B} be a partition into clusters \eqn{B_1, \ldots, B_m}. 
Then for cluster \eqn{A_j} integration is eqaul to: \deqn{Int(A_j) = 
\frac{max_{k = 1, \ldots, m} \# \{  i \in \{ 1, \ldots p \}: x_i \in A_j 
\wedge x_i \in B_k \}  }{\# A_j}} The \eqn{B_k} for which the value is 
maximized is called the integrating cluster of \eqn{A_j}. Then the 
integration for the whole clustering equals is \eqn{Int(A,B) = \frac{1}{n} 
\sum_{j=1}^n Int(A_j)} .The acontamination is defined by: \deqn{Acont(A_j) = 
\frac{ \# \{  i \in \{ 1, \ldots p \}: x_i \in A_j \wedge x_i \in B_k \} }{\#
B_k}} where \eqn{B_k} is the integrating cluster for \eqn{A_j}. Then the 
acontamination for the whole dataset is \eqn{Acont(A,B) = \frac{1}{n} 
\sum_{j=1}^n Acont(A_j)}
}
\examples{
\donttest{
sim.data <- data.simulation(n = 20, SNR = 1, K = 2, numb.vars = 50, max.dim = 2)
true_segmentation <- rep(1:2, each=50)
mlcc.fit <- mlcc.reps(sim.data$X, numb.clusters = 2, max.dim = 2, numb.cores=1)
integration(mlcc.fit$segmentation, true_segmentation)}

}
\references{
{M. Sołtys. Metody analizy skupień. Master’s thesis, Wrocław 
  University of Technology, 2010}
}
