% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Bartlett}
\alias{Bartlett}
\title{Bartlett Data on Plum Root Cuttings}
\format{
A 3-dimensional array resulting from cross-tabulating 3 variables
for 960 observations. The variable names and their levels are:

\tabular{rll}{
dim \tab Name          \tab Levels                \cr
1  \tab \code{Alive}  \tab \verb{"Alive", "Dead"}\cr
2  \tab \code{Time}   \tab \verb{"Now", "Spring"}\cr
3  \tab \code{Length} \tab \verb{"Long", "Short"}\cr
}
}
\source{
Hand, D. and Daly, F. and Lunn, A. D.and McConway, K. J. and Ostrowski, E. (1994). \emph{A Handbook of Small Data Sets}.
London: Chapman & Hall, p. 15, # 19.
}
\description{
In an experiment to investigate the effect of cutting length (two levels)
and planting time (two levels) on the survival of plum root cuttings, 240
cuttings were planted for each of the 2 x 2 combinations of these factors,
and their survival was later recorded.
}
\details{
Bartlett (1935) used these data to illustrate a method for testing for no
three-way interaction in a contingency table.
}
\examples{

data(Bartlett)

# measures of association
assocstats(Bartlett)
oddsratio(Bartlett)

# Test models

## Independence
MASS::loglm(formula = ~Alive + Time + Length, data = Bartlett)

## No three-way association
MASS::loglm(formula = ~(Alive + Time + Length)^2, data = Bartlett)

# Use woolf_test() for a formal test of homogeneity of odds ratios
vcd::woolf_test(Bartlett)


# Plots
fourfold(Bartlett, mfrow=c(1,2))

mosaic(Bartlett, shade=TRUE)
pairs(Bartlett, gp=shading_Friendly)

}
\references{
Bartlett, M. S. (1935).  Contingency Table Interactions \emph{Journal of the Royal Statistical Society}, Supplement,
1935, 2, 248-252.
}
\keyword{datasets}
