% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov.W.R
\name{cov.W}
\alias{cov.W}
\title{Within-group covariance matrix}
\usage{
cov.W(X, groups, sex = NULL, weighted = FALSE)
}
\arguments{
\item{X}{a data matrix with variables in columns and group names as row names}

\item{groups}{a character / factor vector containing grouping variable}

\item{sex}{NULL (default). A character / factor vector containing sex variable,
to remove sexual dimorphism by averaging males and females in each group}

\item{weighted}{logical. If FALSE (default), the average of all the within-group covariance matrices is used.
If TRUE, the within-group covariance matrices are weighted by their sample size.}
}
\value{
The pooled within-group covariance matrix
}
\description{
Computes the pooled within-group covariance matrix.
The effect of sexual dimorphism can be removed by using, for each group,
the average of the covariance matrix of males and the covariance matrix of females.
}
\examples{

# Data matrix of 2D landmark coordinates
data("Tropheus.IK.coord")
coords <- which(names(Tropheus.IK.coord) == "X1"):which(names(Tropheus.IK.coord) == "Y19")
proc.coord <- as.matrix(Tropheus.IK.coord[coords])

# Pooled within-group covariance matrix for all populations (weighted by sample size)
W <- cov.W(proc.coord, groups = Tropheus.IK.coord$POP.ID, weighted = TRUE)

# Pooled within-group covariance matrix for all populations (unweighted)
W <- cov.W(proc.coord, groups = Tropheus.IK.coord$POP.ID)

# Within-group covariance matrix for all populations, pooled by sex
W.mf <- cov.W(proc.coord, groups = Tropheus.IK.coord$POP.ID, sex = Tropheus.IK.coord$Sex)

}
\seealso{
\code{\link[stats:cor]{cov}}
}
