% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relative.eigen.R
\name{relative.eigen}
\alias{relative.eigen}
\title{Relative eigenanalysis}
\usage{
relative.eigen(S1, S2, method = 0, pa = 0)
}
\arguments{
\item{S1}{a variance-covariance matrix}

\item{S2}{a variance-covariance matrix}

\item{method}{an integer for the method of matrix inversion (see function 'minv')}

\item{pa}{an integer for the parameter of matrix inversion (see function 'minv')}
}
\value{
A list containing the following named components:
\item{relValues}{the vector of relative eigenvalues}
\item{relVectors}{the matrix of relative eigenvectors}
\item{distCov}{the distance between the two covariance matrices}
\item{relGV}{the product of the nonzero relative eigenvalues = the ratio of the generalized variances.
The generalized variance corresponds to the determinant of the covariance matrix.}
\item{logGV}{the log ratio of the generalized variances}
\item{q}{the number of nonzero eigenvalues}
}
\description{
Computes the Riemanian distance between two variance-covariance matrices of same dimensions and the relative eigenvectors and eigenvalues of S1 with respect to S2
}
\examples{

# Data matrix of 2D landmark coordinates
data("Tropheus.IK.coord")
coords <- which(names(Tropheus.IK.coord) == "X1"):which(names(Tropheus.IK.coord) == "Y19")
proc.coord <- as.matrix(Tropheus.IK.coord[coords])

# Data reduction
phen.pca <- prcomp(proc.coord, rank. = 5, tol = sqrt(.Machine$double.eps))
pc.scores <- phen.pca$x

# Covariance matrix of each population
S.phen.pop <- cov.group(pc.scores, groups = Tropheus.IK.coord$POP.ID)

# Relative PCA = relative eigenanalysis between 2 covariance matrices
# (population IKA1 relative to IKS5)
relEigen.a1s5 <- relative.eigen(S.phen.pop[, , "IKA1"], S.phen.pop[, , "IKS5"])

}
\references{
Bookstein F, Mitteroecker P (2014)
Comparing covariance matrices by relative eigenanalysis, with applications to organismal biology.
\emph{Evolutionary Biology 41}: 336-350.
\url{https://doi.org/10.1007/s11692-013-9260-5}
}
\seealso{
See \code{\link{minv}} for the method and the parameter used for the matrix inversion
}
