% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin.r
\encoding{UTF-8}
\name{bin_x}
\alias{bin_x}
\title{Group continuous data values (x-axis)}
\usage{
bin_x(vl, min = NULL, max = NULL, base = NULL, step = NULL,
  steps = NULL, minstep = NULL, div = NULL, maxbins = NULL)
}
\arguments{
\item{vl}{Vega-Lite object}

\item{min}{the minimum bin value to consider.}

\item{max}{the maximum bin value to consider.}

\item{base}{the number base to use for automatic bin determination.}

\item{step}{an exact step size to use between bins.}

\item{steps}{an array of allowable step sizes to choose from.}

\item{minstep}{minimum allowable step size (particularly useful for integer values).}

\item{div}{Scale factors indicating allowable subdivisions. The default value is
[5, 2], which indicates that for base 10 numbers (the default base),
the method may consider dividing bin sizes by 5 and/or 2. For example,
for an initial step size of 10, the method can check if bin sizes of 2
(= 10/5), 5 (= 10/2), or 1 (= 10/(5*2)) might also satisfy the given
 constraints.}

\item{maxbins}{the maximum number of allowable bins.}
}
\description{
The "bin" property is for grouping quantitative, continuous data values of a
particular field into smaller number of “bins” (e.g., for a histogram).
}
\examples{
vegalite() \%>\%
  add_data("https://vega.github.io/vega-editor/app/data/movies.json") \%>\%
  encode_x("IMDB_Rating", "quantitative") \%>\%
  encode_y("Rotten_Tomatoes_Rating", "quantitative") \%>\%
  encode_size("*", "quantitative", aggregate="count") \%>\%
  bin_x(maxbins=10) \%>\%
  bin_y(maxbins=10) \%>\%
  mark_point()
}
\references{
\href{http://vega.github.io/vega-lite/docs/bin.html}{Vega-Lite Binning}
}

