% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plt.2dcm.R
\name{plt.2dcm}
\alias{plt.2dcm}
\title{Create a ggplot Plot from a 2D Correlation Matrix}
\usage{
plt.2dcm(
  data,
  mapping = NULL,
  ...,
  show.stat = TRUE,
  environment = parent.frame()
)
}
\arguments{
\item{data}{A numeric 2D matrix of correlation coefficients.}

\item{mapping}{Optional ggplot2 aesthetic mapping.}

\item{...}{Additional arguments passed to \code{ggplot}.}

\item{show.stat}{Logical. If \code{TRUE}, prints the best \eqn{R^2} value and corresponding bands.}

\item{environment}{The environment in which to evaluate the plot. Defaults to \code{parent.frame()}.}
}
\value{
A ggplot object visualizing the correlation matrix.
}
\description{
This function creates a ggplot visualization from a 2D correlation matrix,
such as those produced by \code{cm.sr} or \code{cm.nsr}. The function attempts
to extract numeric wavelengths from the column names. If the extraction fails,
sequential indices are used.
}
\details{
It replaces the former \code{ggplot.cm()}.

The function extracts numeric wavelengths from the column names of \code{data}.
If these cannot be determined, sequential indices are used instead.
}
\examples{
\dontrun{
  library(visa)
  data(NSpec.DF)
  x <- NSpec.DF$N  # nitrogen
  S <- NSpec.DF$spectra[, seq(1, ncol(NSpec.DF$spectra), 10)]  # resampled to 10 nm steps
  cm2d <- cm.sr(S, x, cm.plot = FALSE)
  p2d <- plt.2dcm(cm2d)
  print(p2d)
}

}
