% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_annotation_dist}
\alias{plot_annotation_dist}
\title{Plot distribution of annotation data across clusters}
\usage{
plot_annotation_dist(annotations_df, cluster_labels, selected_clusters = NULL)
}
\arguments{
\item{annotations_df}{data frame with variables not used in clustering}

\item{cluster_labels}{output from \code{\link[=cut_clusters]{cut_clusters()}}}

\item{selected_clusters}{optional vector of cluster labels to include in plots}
}
\value{
a \code{patchwork} object
}
\description{
Plot distribution of annotation data across clusters
}
\examples{
dmat <- compute_dmat(iris, "euclidean", TRUE, c("Petal.Length", "Sepal.Length"))
clusters <- compute_clusters(dmat, "complete")
cluster_labels <- cut_clusters(clusters, 2)
plot_annotation_dist(iris["Species"], cluster_labels)
}
