% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_metrics}
\alias{plot_metrics}
\title{Output a plot with distribution parameters such as the mean values}
\usage{
plot_metrics(data, cols, cross = NULL, metric = FALSE, clean = TRUE, ...)
}
\arguments{
\item{data}{A data frame.}

\item{cols}{A tidy column selection,
e.g. a single column (without quotes)
or multiple columns selected by methods such as starts_with().}

\item{cross}{Optional, a grouping column (without quotes).}

\item{metric}{When crossing variables, the cross column parameter can contain categorical or metric values.
By default, the cross column selection is treated as categorical data.
Set metric to TRUE, to treat it as metric and calculate correlations.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Other parameters passed to the appropriate plot function.}
}
\value{
A ggplot object.
}
\description{
The plot type depends on the number of selected columns:
\itemize{
\item One metric column: see \link{plot_metrics_one}
\item Multiple metric columns: see \link{plot_metrics_items}
}

Group comparisons:
\itemize{
\item One metric column and one grouping column: see \link{plot_metrics_one_grouped}
\item Multiple metric columns and one grouping column: see \link{plot_metrics_items_grouped}
\item Multiple metric columns and multiple grouping columns: see \link{plot_metrics_items_grouped_items} (not yet implemented)
}

By default, if you provide two column selections, the second selection is treated as categorical.
Setting the metric-parameter to TRUE will call the appropriate functions for correlation analysis:
\itemize{
\item Two metric columns: see \link{plot_metrics_one_cor}
\item Multiple metric columns and one metric column : see \link{plot_metrics_items_cor}
\item Two metric column selections: see \link{plot_metrics_items_cor_items}
}

Parameters that may be passed to the metric functions
(see the respective function help):
\itemize{
\item \strong{ci}: Plot confidence intervals for means or correlation coefficients.
\item \strong{box}: Visualise the distribution by adding boxplots.
\item \strong{log}: In scatter plots, you can use a logarithmic scale.
Be aware, that zero values will be omitted because their log value is undefined.
\item \strong{method}: By default, correlations are calculated using Pearson’s R.
You can choose Spearman’s Rho with the methods-parameter.
\item \strong{limits}: The scale limits are automatically guessed by the package functions (work in progress).
Use the limits-parameter to manually fix any misleading graphs.
\item \strong{title}: All plots usually get a title derived from the column attributes or column names.
Set to FALSE to suppress the title or provide a title of your choice as a character value.
\item \strong{labels}: Labels are extracted from the column attributes.
Set to FALSE to output bare column names and values.
\item \strong{numbers}: Controls whether to display correlation coefficients on the plot. Use \code{TRUE} to show coefficients and \code{FALSE} (or \code{NULL}) to hide them.
}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
library(volker)
data <- volker::chatgpt

plot_metrics(data, sd_age)

}
