% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inequalityMeasure.R
\name{Quantile}
\alias{Quantile}
\title{Sample quantile for weighted data}
\usage{
Quantile(X, W = rep(1, length(X)), p = 0.5)
}
\arguments{
\item{X}{is a numeric data vector}

\item{W}{is a vector of weights}

\item{p}{is a probability to derive corresponding quantile}
}
\value{
The quantile for weighted data.
}
\description{
Computes quantile derived for the given probability taking into account weights.
}
\details{
Linear interpolation is applied to deal with a frequency distribution.
}
\examples{
# Compare weighted and unweighted result
X=1:10
W=10:1
Quantile(X,p=0.5)
Quantile(X,W,p=0.5)

}
