% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waitress.R
\name{waitressClass}
\alias{waitressClass}
\alias{Waitress}
\title{Waitress R6 Class}
\description{
Create a waitress (progress bar) and programmatically set or increase 
its percentage, then hide it when done.
}
\examples{

## ------------------------------------------------
## Method `Waitress$new`
## ------------------------------------------------

\dontrun{Waitress$new("#plot")}

## ------------------------------------------------
## Method `Waitress$start`
## ------------------------------------------------

\dontrun{Waitress$new("#plot")$start()}

## ------------------------------------------------
## Method `Waitress$notify`
## ------------------------------------------------

\dontrun{Waitress$new()$notify()}

## ------------------------------------------------
## Method `Waitress$set`
## ------------------------------------------------

\dontrun{Waitress$new("#plot")$set(20)}

## ------------------------------------------------
## Method `Waitress$auto`
## ------------------------------------------------

\dontrun{Waitress$new("#plot")$auto(20, 2000)}

## ------------------------------------------------
## Method `Waitress$inc`
## ------------------------------------------------

\dontrun{Waitress$new("#plot")$inc(30)}

## ------------------------------------------------
## Method `Waitress$close`
## ------------------------------------------------

\dontrun{Waitress$new("#plot")$close()}

## ------------------------------------------------
## Method `Waitress$print`
## ------------------------------------------------

\dontrun{Waitress$new("#plot")$hide()}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{max}}{Maximum value of the bar.}

\item{\code{min}}{Minimum value of the bar.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-waitress-new}{\code{Waitress$new()}}
\item \href{#method-waitress-start}{\code{Waitress$start()}}
\item \href{#method-waitress-notify}{\code{Waitress$notify()}}
\item \href{#method-waitress-set}{\code{Waitress$set()}}
\item \href{#method-waitress-auto}{\code{Waitress$auto()}}
\item \href{#method-waitress-inc}{\code{Waitress$inc()}}
\item \href{#method-waitress-close}{\code{Waitress$close()}}
\item \href{#method-waitress-getMin}{\code{Waitress$getMin()}}
\item \href{#method-waitress-getMax}{\code{Waitress$getMax()}}
\item \href{#method-waitress-getValue}{\code{Waitress$getValue()}}
\item \href{#method-waitress-print}{\code{Waitress$print()}}
\item \href{#method-waitress-clone}{\code{Waitress$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-waitress-new"></a>}}
\if{latex}{\out{\hypertarget{method-waitress-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Waitress$new(
  selector = NULL,
  theme = c("line", "overlay", "overlay-radius", "overlay-opacity", "overlay-percent"),
  min = 0,
  max = 100,
  infinite = FALSE,
  hide_on_render = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{selector}}{Element selector to apply the waitress to, 
if \code{NULL} then the waitress is applied to the whole screen.}

\item{\code{theme}}{A valid theme, see function usage.}

\item{\code{min, max}}{Minimum and maximum representing the starting and ending
points of the progress bar.}

\item{\code{infinite}}{Set to \code{TRUE} to create a never ending loading bar, ideal
when you cannot compute increments or assess the time it might take before the
loading bar should be removed.}

\item{\code{hide_on_render}}{Set to \code{TRUE} to automatically hide the waitress
when the element in \code{id} is rendered. Note the latter will work with
shiny plots, tables, htmlwidgets, etc. but will not work with arbitrary
elements.}

\item{\code{color, percent_color}}{Color of waitress and color of percent text shown when 
\code{theme} is set to \code{overlay-percent}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Create a waitress.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Waitress$new("#plot")}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-waitress-start"></a>}}
\if{latex}{\out{\hypertarget{method-waitress-start}{}}}
\subsection{Method \code{start()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Waitress$start(
  html = NULL,
  background_color = "transparent",
  text_color = "black"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{html}}{HTML content to show over the waitress, 
accepts htmltools and shiny tags.}

\item{\code{background_color}}{The background color of the html.}

\item{\code{text_color}}{The color of the \code{html} content.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Start the waitress.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Waitress$new("#plot")$start()}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-waitress-notify"></a>}}
\if{latex}{\out{\hypertarget{method-waitress-notify}{}}}
\subsection{Method \code{notify()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Waitress$notify(
  html = NULL,
  background_color = "white",
  text_color = "black",
  position = c("br", "tr", "bl", "tl")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{html}}{HTML content to show over the waitress, 
accepts htmltools and shiny tags.}

\item{\code{background_color}}{The background color of the html.}

\item{\code{text_color}}{The color of the \code{html} content.}

\item{\code{position}}{Position of the notification on the screen.
Where \code{br} is the bottom-right, \code{tr} is the top-right,
\code{bl} is bottom-left, and \code{tl} is the top-left.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Show the waitress as a notification.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Waitress$new()$notify()}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-waitress-set"></a>}}
\if{latex}{\out{\hypertarget{method-waitress-set}{}}}
\subsection{Method \code{set()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Waitress$set(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Value to set waitress to.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Set the waitress to a specific percentage.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Waitress$new("#plot")$set(20)}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-waitress-auto"></a>}}
\if{latex}{\out{\hypertarget{method-waitress-auto}{}}}
\subsection{Method \code{auto()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Waitress$auto(value, ms)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Value to set waitress to.}

\item{\code{ms}}{Number of Milliseconds}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Automatically start and end the waitress.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Waitress$new("#plot")$auto(20, 2000)}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-waitress-inc"></a>}}
\if{latex}{\out{\hypertarget{method-waitress-inc}{}}}
\subsection{Method \code{inc()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Waitress$inc(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Value to increase waitress to.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Increase the waitress by a percentage.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Waitress$new("#plot")$inc(30)}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-waitress-close"></a>}}
\if{latex}{\out{\hypertarget{method-waitress-close}{}}}
\subsection{Method \code{close()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Waitress$close()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Close the waitress.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Waitress$new("#plot")$close()}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-waitress-getMin"></a>}}
\if{latex}{\out{\hypertarget{method-waitress-getMin}{}}}
\subsection{Method \code{getMin()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Waitress$getMin()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get minimum value
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-waitress-getMax"></a>}}
\if{latex}{\out{\hypertarget{method-waitress-getMax}{}}}
\subsection{Method \code{getMax()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Waitress$getMax()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get maximum value
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-waitress-getValue"></a>}}
\if{latex}{\out{\hypertarget{method-waitress-getValue}{}}}
\subsection{Method \code{getValue()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Waitress$getValue()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get current value
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-waitress-print"></a>}}
\if{latex}{\out{\hypertarget{method-waitress-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Waitress$print()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Print the waitress.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Waitress$new("#plot")$hide()}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-waitress-clone"></a>}}
\if{latex}{\out{\hypertarget{method-waitress-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Waitress$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
