% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_accelerometry_counts_into_bouts.R
\name{identify_complete_days}
\alias{identify_complete_days}
\title{Identify complete wearing days
This function identifies complete days based on accelerometry data by
calculating the total number of epochs worn per day and comparing it to the
minimum number of wearing epochs per day required to consider a day complete.}
\usage{
identify_complete_days(
  accelerometry_counts,
  min_wearing_hours_per_day,
  epoch_length,
  local_time_zone
)
}
\arguments{
\item{accelerometry_counts}{A data frame containing accelerometry counts and non-wearing epochs.}

\item{min_wearing_hours_per_day}{Minimum number of hours of wearing time required for a day to be considered complete.}

\item{epoch_length}{The duration of an epoch in seconds.}

\item{local_time_zone}{The local time zone of the data. The data come in and are returned in UTC, but the local time zone is used to compute complete_days.}
}
\value{
A data frame containing accelerometer counts, non-wearing epochs, and a binary variable indicating if the day is complete or not.
}
\description{
Identify complete wearing days
This function identifies complete days based on accelerometry data by
calculating the total number of epochs worn per day and comparing it to the
minimum number of wearing epochs per day required to consider a day complete.
}
