% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nr_neighbors.R
\name{nr_neighbors}
\alias{nr_neighbors}
\title{Calculate the Number of Neighbors for a Warehouse Location}
\usage{
nr_neighbors(product, location, goods_and_locations, warehouse_height)
}
\arguments{
\item{product}{The product for which neighbors are being calculated.}

\item{location}{The specific location of the product in the warehouse.}

\item{goods_and_locations}{A data frame containing the products and their corresponding locations in the warehouse. It should have at least two columns: `product` and `location`.}

\item{warehouse_height}{warehouse height}
}
\value{
An integer representing the number of neighboring products at the specified location.
}
\description{
This function calculates the number of neighboring products for a specific product at a given location in the warehouse.
}
\details{
The function calculates how many products share a similar location pattern in the warehouse by grouping locations and checking whether they fall within the same row or column as the provided location. The function returns the total number of products in the same general area, excluding the current product.
}
\examples{
scenario <- generate_sample_goods_and_locatons_scenario()
nr <- nr_neighbors(1,1,scenario,25)
}
\references{
Dmytrów, K. (2022). Analytical and simulation determination of order picking time in a low storage warehouse for shared storage systems. Operations Research and Decisions, 32(2), 34–51. \doi{10.37190/ord220203}
}
\author{
Krzysztof Dmytrów \email{krzysztof.dmytrow@usz.edu.pl} [aut] \href{https://orcid.org/0000-0001-7657-6063}{ORCID: 0000-0001-7657-6063}

Andrzej Dudek \email{andrzej.dudek@ue.wroc.pl} [aut, cre] \href{https://orcid.org/0000-0002-4943-8703}{ORCID: 0000-0002-4943-8703}
}
