% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wconfusionmatrix.R
\name{wconfusionmatrix}
\alias{wconfusionmatrix}
\title{Weighted confusion matrix}
\usage{
wconfusionmatrix(m, weight.type = "arithmetic",
                        weight.penalty = FALSE,
                        standard.deviation = 2,
                        geometric.multiplier = 2,
                        interval.high=1, interval.low = -1,
                        sin.high=1.5*pi, sin.low = 0.5*pi,
                        tanh.decay = 3,
                        custom.weights = NA,
                        print.weighted.accuracy = FALSE)
}
\arguments{
\item{m}{the caret confusion matrix object or simple matrix.}

\item{weight.type}{the weighting schema to be used. Can be one of:
"arithmetic" - a decreasing arithmetic progression weighting scheme,
"geometric" - a decreasing geometric progression weighting scheme,
"normal" - weights drawn from the right tail of a normal distribution,
"interval" - weights contained on a user-defined interval,
"sin" - a weighing scheme based on a sine function,
"tanh" - a weighing scheme based on a hyperbolic tangent function,
"custom" - custom weight vector defined by the user.}

\item{weight.penalty}{determines whether the weights associated with
non-diagonal elements generated by the "normal", "arithmetic" and "geometric"
weight types are positive or negative values. By default, the value is set to
FALSE, which means that generated weights will be positive values.}

\item{standard.deviation}{standard deviation of the normal distribution, if
the normal distribution weighting schema is used.}

\item{geometric.multiplier}{the multiplier used to construct the geometric
progression series, if the geometric progression weighting scheme is used.}

\item{interval.high}{the upper bound of the weight interval, if the interval
weighting scheme is used.}

\item{interval.low}{the lower bound of the weight interval, if the interval
weighting scheme is used.}

\item{sin.high}{the upper segment of the sine function to be used in the
weighting scheme.}

\item{sin.low}{the lower segment of the sine function to be used in the
weighting scheme.}

\item{tanh.decay}{the decay factor of the hyperbolic tangent weighing
function. Higher values increase the rate of decay and place less weight on
observations farther away from the correctly predicted category.}

\item{custom.weights}{the vector of custom weight to be applied, if the
custom weighting scheme was selected. The vector should be equal to "n", but
can be larger, with excess values being ignored.}

\item{print.weighted.accuracy}{print the weighted accuracy metric, which
represents the sum of all weighted confusion matrix cells divided by the
total number of observations.}
}
\value{
an nxn weighted confusion matrix
}
\description{
This function calculates the weighted confusion matrix from a caret
ConfusionMatrix object or a simple matrix, according to one of several
weighting schemas and optionally prints the weighted accuracy score.
}
\details{
The number of categories "n" should be greater or equal to 2.
}
\examples{
m = matrix(c(70,0,0,10,10,0,5,3,2), ncol = 3, nrow=3)
wconfusionmatrix(m, weight.type="arithmetic", print.weighted.accuracy = TRUE)
wconfusionmatrix(m, weight.type="geometric", print.weighted.accuracy = TRUE)
wconfusionmatrix(m, weight.type="interval", print.weighted.accuracy = TRUE)
wconfusionmatrix(m, weight.type="normal", print.weighted.accuracy = TRUE)
wconfusionmatrix(m, weight.type="sin", print.weighted.accuracy = TRUE)
wconfusionmatrix(m, weight.type="tanh", print.weighted.accuracy = TRUE)
wconfusionmatrix(m, weight.type= "custom", custom.weights = c(1,0.1,0),
                 print.weighted.accuracy = TRUE)

}
\seealso{
[weightmatrix()] for the weight matrix used in computations,
  [balancedaccuracy()] for accuracy metrics designed for imbalanced data.
}
\author{
Alexandru Monahov, <https://www.alexandrumonahov.eu.org/>
}
\keyword{accuracy}
\keyword{confusion}
\keyword{matrix}
\keyword{score}
\keyword{weighted}
