% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{wdpar}
\alias{wdpar}
\alias{wdpar-package}
\title{wdpar: Interface to the World Database on Protected Areas}
\description{
The \pkg{wdpar} R package provides an interface to data provided by
\href{https://www.protectedplanet.net/en}{Protected Planet}.
Specifically, it can be used to automatically obtain data from
the World Database on Protected Areas
(WDPA) and the World Database on Other Effective Area-Based Conservation
Measures (WDOECM).
It also provides methods for cleaning data from these databases following
best practices
(outlined in Butchart \emph{et al.} 2015; Protected Planet 2021; Runge \emph{et al.}
2015). The main functions are \code{\link[=wdpa_fetch]{wdpa_fetch()}}
for downloading data and \code{\link[=wdpa_clean]{wdpa_clean()}} for cleaning data. For
more information, please see the package vignette.
To cite this package, please see \code{citation("wdpar")}.
}
\references{
Butchart SH, Clarke M, Smith RJ, Sykes RE, Scharlemann JP,
Harfoot M, ... & Brooks TM (2015) Shortfalls and solutions for
meeting national and global conservation area targets.
\emph{Conservation Letters}, \strong{8}: 329--337.

Protected Planet (2021) Calculating protected and OECM area coverage.
Available at:
\url{https://www.protectedplanet.net/en/resources/calculating-protected-area-coverage}.

Runge CA, Watson JEM, Butchart HM, Hanson JO, Possingham HP & Fuller RA
(2015) Protected areas and global conservation of migratory birds.
\emph{Science}, \strong{350}: 1255--1258.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://prioritizr.github.io/wdpar/}
  \item \url{https://github.com/prioritizr/wdpar}
  \item Report bugs at \url{https://github.com/prioritizr/wdpar/issues}
}

}
\author{
\strong{Maintainer}: Jeffrey O Hanson \email{jeffrey.hanson@uqconnect.edu.au}

}
