% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temperature_conversions.R
\name{kelvin.to.celsius}
\alias{kelvin.to.celsius}
\title{Convert from Kelvin to Celsius.}
\usage{
kelvin.to.celsius(T.kelvin, round = 2)
}
\arguments{
\item{T.kelvin}{Numeric vector of temperatures in Kelvin.}

\item{round}{An integer indicating the number of decimal places to
round the converted value.}
}
\value{
A numeric vector of temperature values in Celsius.
}
\description{
\code{kelvin.to.celsius} creates a numeric vector of temperatures in
   Celsius from a numeric vector of temperatures in Kelvin.
}
\note{
Equations are from the source code for the National Oceanic and
     Atmospheric Association's
    \href{http://www.srh.noaa.gov/epz/?n=wxcalc_tempconvert}{online
    temperature converter}.
}
\examples{
# Convert from Kelvin to Celsius.
data(angeles)
angeles$TemperatureC <- kelvin.to.celsius(angeles$TemperatureK)
angeles

}
\author{
Joshua Ferreri \email{joshua.m.ferreri@gmail.com},
Brooke Anderson \email{brooke.anderson@colostate.edu}
}
\seealso{
\code{\link{celsius.to.kelvin}}
}

