% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wind_conversions.R
\name{knots_to_speed}
\alias{knots_to_speed}
\title{Convert from knots to standard units of wind speed}
\usage{
knots_to_speed(knots, unit, round = 1)
}
\arguments{
\item{knots}{Numeric vector of speeds in knots}

\item{unit}{Character specifying the speed unit other than knots.
Possible values are:
  \itemize{
    \item \code{mph}: Miles per hour
    \item \code{mps}: Meters per second
    \item \code{ftps}: Feet per second
    \item \code{kmph}: Kilometers per hour
  }}

\item{round}{An integer indicating the number of decimal places to
round the converted value.}
}
\value{
A numeric vector of speeds (in the specified unit)
}
\description{
\code{knots_to_speed} creates a numeric vector of speed, in units
   specified by \code{unit}, from a numeric vector of speed in knots.
}
\details{
Output will be in the speed units specified by \code{unit}.
}
\note{
Equations are from the source code for the National Oceanic and
  and Atmospheric Administration's
  \href{http://www.srh.noaa.gov/epz/?n=wxcalc_windconvert}{online wind speed
  converter}
}
\examples{
data(foco)
foco$mph <- knots_to_speed(foco$knots, unit = "mph", round = 0)
foco$mps <- knots_to_speed(foco$knots, unit = "mps", round = NULL)
foco$ftps <- knots_to_speed(foco$knots, unit = "ftps")
foco$kmph <- knots_to_speed(foco$knots, unit = "kmph")
foco

}
\author{
Joshua Ferreri \email{joshua.m.ferreri@gmail.com},
Brooke Anderson \email{brooke.anderson@colostate.edu}
}
\references{
\url{http://www.srh.noaa.gov/epz/?n=wxcalc_windconvert}
}
\seealso{
\code{\link{speed_to_knots}}
}

