% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_leaders.R
\name{wnba_assisttracker}
\alias{wnba_assisttracker}
\title{\strong{Get WNBA Stats API Assist Tracker}}
\usage{
wnba_assisttracker(
  league_id = "10",
  per_mode = "PerGame",
  season = most_recent_wnba_season() - 1,
  season_type = "Regular Season",
  ...
)
}
\arguments{
\item{league_id}{League - default: '00'. Other options include '10': WWNBA, '20': G-League}

\item{per_mode}{Per Mode - PerGame, Totals}

\item{season}{Season - format 2020-21}

\item{season_type}{Season Type - Regular Season, Playoffs, All-Star}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: AssistTracker

\strong{AssistTracker}\tabular{ll}{
   col_name \tab types \cr
   ASSISTS \tab numeric \cr
}
}
\description{
\strong{Get WNBA Stats API Assist Tracker}

\strong{Get WNBA Stats API Assist Tracker}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{  wnba_assisttracker(league_id = '10')
}\if{html}{\out{</div>}}
}
\seealso{
Other WNBA Leaders Functions: 
\code{\link{wnba_alltimeleadersgrids}()},
\code{\link{wnba_assistleaders}()},
\code{\link{wnba_homepagewidget}()},
\code{\link{wnba_leagueleaders}()}
}
\author{
Saiem Gilani
}
\concept{WNBA Leaders Functions}
