% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_roster.R
\name{wnba_commonallplayers}
\alias{wnba_commonallplayers}
\title{\strong{Get WNBA Stats API All Players}}
\usage{
wnba_commonallplayers(
  is_only_current_season = 0,
  league_id = "10",
  season = most_recent_wnba_season() - 1,
  ...
)
}
\arguments{
\item{is_only_current_season}{is_only_current_season}

\item{league_id}{league_id}

\item{season}{season}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: CommonAllPlayers

\strong{CommonAllPlayers}\tabular{ll}{
   col_name \tab types \cr
   PERSON_ID \tab character \cr
   DISPLAY_LAST_COMMA_FIRST \tab character \cr
   DISPLAY_FIRST_LAST \tab character \cr
   ROSTERSTATUS \tab character \cr
   FROM_YEAR \tab character \cr
   TO_YEAR \tab character \cr
   PLAYERCODE \tab character \cr
   PLAYER_SLUG \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_CITY \tab character \cr
   TEAM_NAME \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_CODE \tab character \cr
   TEAM_SLUG \tab character \cr
   IS_NBA_ASSIGNED \tab character \cr
   NBA_ASSIGNED_TEAM_ID \tab character \cr
   GAMES_PLAYED_FLAG \tab character \cr
}
}
\description{
\strong{Get WNBA Stats API All Players}

\strong{Get WNBA Stats API All Players}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{  wnba_commonallplayers(league_id = '10', season = most_recent_wnba_season() - 1)
}\if{html}{\out{</div>}}
}
\seealso{
Other WNBA Roster Functions: 
\code{\link{wnba_commonplayerinfo}()},
\code{\link{wnba_commonteamroster}()}
}
\author{
Saiem Gilani
}
\concept{WNBA Roster Functions}
