% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihood_functions.R
\encoding{UTF-8}
\name{loglik_profiling}
\alias{loglik_profiling}
\alias{loglik_profiling.wt_reliability_data}
\title{Log-Likelihood Profile Function for Parametric Lifetime Distributions with Threshold}
\usage{
loglik_profiling(x, ...)

\method{loglik_profiling}{wt_reliability_data}(
  x,
  wts = rep(1, nrow(x)),
  thres,
  distribution = c("weibull3", "lognormal3", "loglogistic3", "exponential2"),
  ...
)
}
\arguments{
\item{x}{A \code{tibble} with class \code{wt_reliability_data} returned by \link{reliability_data}.}

\item{...}{Further arguments passed to or from other methods. Currently not used.}

\item{wts}{Optional vector of case weights. The length of \code{wts} must be equal
to the number of observations in \code{x}.}

\item{thres}{A numeric value for the threshold parameter.}

\item{distribution}{Supposed parametric distribution of the random variable.}
}
\value{
Returns the log-likelihood value for the threshold parameter \code{thres} given
the data.
}
\description{
This function evaluates the log-likelihood with respect to a given threshold
parameter of a parametric lifetime distribution. In terms of
\emph{Maximum Likelihood Estimation} this function can be optimized
(\link[stats:optim]{optim}) to estimate the threshold parameter.
}
\examples{
# Reliability data preparation:
data <- reliability_data(
  alloy,
  x = cycles,
  status = status
)

# Determining the optimal loglikelihood value:
## Range of threshold parameter must be smaller than the first failure:
threshold <- seq(
  0,
  min(data$x[data$status == 1]) - 0.1,
  length.out = 50
)

## loglikelihood value with respect to threshold values:
profile_logL <- loglik_profiling(
  x = data,
  thres = threshold,
  distribution = "weibull3"
)

## Threshold value (among the candidates) that maximizes the
## loglikelihood:
threshold[which.max(profile_logL)]

## plot:
plot(
  threshold,
  profile_logL,
  type = "l"
)
abline(
  v = threshold[which.max(profile_logL)],
  h = max(profile_logL),
  col = "red"
)

}
\references{
Meeker, William Q; Escobar, Luis A., Statistical methods for
reliability data, New York: Wiley series in probability and statistics, 1998
}
