% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcs_data.R
\name{mcs_mileage_data}
\alias{mcs_mileage_data}
\title{MCS Mileage Data}
\usage{
mcs_mileage_data(
  data = NULL,
  mileage,
  time,
  status = NULL,
  id = NULL,
  .keep_all = FALSE
)
}
\arguments{
\item{data}{Either \code{NULL} or a \code{data.frame}. If data is \code{NULL}, \code{mileage}, \code{time},
\code{status} and \code{id} must be vectors containing the data. Otherwise \code{mileage}, \code{time},
\code{status} and \code{id} can be either column names or column positions.}

\item{mileage}{Covered distances. Use \code{NA} for missing elements.}

\item{time}{Operating times. Use \code{NA} for missing elements.}

\item{status}{Optional argument. If used, it must contain binary data
(0 or 1) indicating whether a unit is a right censored observation (= 0) or a
failure (= 1).

If \code{status} is provided, class \code{wt_reliability_data} is assigned to the
output of \link{mcs_mileage}, which enables the direct application of \link{estimate_cdf}
on distances.}

\item{id}{Identification of every unit.}

\item{.keep_all}{If \code{TRUE} keep remaining variables in \code{data}.}
}
\value{
A \code{tibble} with class \code{wt_mcs_mileage_data} that is formed for the downstream
Monte Carlo method \link{mcs_mileage}.
It contains the following columns (if \code{.keep_all = FALSE}):
\itemize{
\item \code{mileage} : Input mileages.
\item \code{time} : Input operating times.
\item \code{status} (\strong{optional}) :
\itemize{
\item If \code{is.null(status)} column \code{status} does not exist.
\item If \code{status} is provided the column contains the entered binary
data (0 or 1).
}
\item \code{id} : Identification for every unit.
}

If \code{.keep_all = TRUE}, the remaining columns of \code{data} are also preserved.

The attribute \code{mcs_characteristic} is set to \code{"mileage"}.
}
\description{
Create consistent \code{mcs_mileage_data} based on an existing \code{data.frame} (preferred)
or on multiple equal length vectors
}
\examples{
# Example 1 -  Based on an existing data.frame/tibble and column names:
mcs_tbl <- mcs_mileage_data(
  data = field_data,
  mileage = mileage,
  time = dis,
  status = status
)

# Example 2 - Based on an existing data.frame/tibble and column positions:
mcs_tbl_2 <- mcs_mileage_data(
  data = field_data,
  mileage = 3,
  time = 2,
  id = 1
)

# Example 3 - Keep all variables of the tibble/data.frame entered to argument data:
mcs_tbl_3 <- mcs_mileage_data(
  data = field_data,
  mileage = mileage,
  time = dis,
  status = status,
  id = vin,
  .keep_all = TRUE
)

# Example 4 - Based on vectors:
mcs_tbl_4 <- mcs_mileage_data(
  mileage = field_data$mileage,
  time = field_data$dis,
  status = field_data$status,
  id = field_data$vin
)

}
\seealso{
\link{dist_mileage} for the determination of a parametric annual mileage
distribution and \link{mcs_mileage} for the Monte Carlo method with respect to
unknown distances.
}
