% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_conf.default}
\alias{plot_conf.default}
\title{Add Confidence Region(s) for Quantiles and Probabilities}
\usage{
\method{plot_conf}{default}(
  p_obj,
  x,
  y,
  distribution = c("weibull", "lognormal", "loglogistic", "sev", "normal", "logistic",
    "weibull3", "lognormal3", "loglogistic3", "exponential", "exponential2"),
  direction = c("y", "x"),
  title_trace = "Confidence Limit",
  ...
)
}
\arguments{
\item{p_obj}{A plot object returned by \link{plot_mod}.}

\item{x}{A list containing the x-coordinates of the confidence region(s). The
list can be of length 1 or 2. For more information see \strong{Details}.}

\item{y}{A list containing the y-coordinates of the Confidence Region(s).
The list can be of length 1 or 2. For more information see \strong{Details}.}

\item{distribution}{Supposed distribution of the random variable.}

\item{direction}{A character string specifying the direction of the plotted
interval(s). \code{"y"} for failure probabilities or \code{"x"} for quantiles.}

\item{title_trace}{A character string which is assigned to the legend trace.}

\item{...}{Further arguments passed to or from other methods. Currently not used.}
}
\value{
A plot object containing the probability plot with plotting positions,
the estimated regression line and the estimated confidence region(s).
}
\description{
This function is used to add estimated confidence region(s) to an existing
probability plot which also includes the estimated regression line.
}
\details{
It is important that the length of the vectors provided as lists in \code{x} and
\code{y} match with the length of the vectors \code{x} and \code{y} in the function \link{plot_mod}.
For this reason the following procedure is recommended:
\itemize{
\item Calculate confidence intervals with the function \link{confint_betabinom} or
\link{confint_fisher} and store it in a \code{data.frame}. For instance call it df.
\item Inside \link{plot_mod} use the output \code{df$x} for \code{x} and \code{df$prob} for \code{y} of
the function(s) named before.
\item In \strong{Examples} the described approach is shown with code.
}
}
\examples{
# Vectors:
cycles <- alloy$cycles
status <- alloy$status

prob_tbl <- estimate_cdf(x = cycles, status = status, method = "johnson")

# Example 1 - Probability Plot, Regression Line and Confidence Bounds for Three-Parameter-Weibull:
rr <- rank_regression(
  x = prob_tbl$x,
  y = prob_tbl$prob,
  status = prob_tbl$status,
  distribution = "weibull3"
)

conf_betabin <- confint_betabinom(
  x = prob_tbl$x,
  status = prob_tbl$status,
  dist_params = rr$coefficients,
  distribution = "weibull3"
)

plot_weibull <- plot_prob(
  x = prob_tbl$x,
  y = prob_tbl$prob,
  status = prob_tbl$status,
  id = prob_tbl$id,
  distribution = "weibull"
)

plot_reg_weibull <- plot_mod(
  p_obj = plot_weibull,
  x = conf_betabin$x,
  y = conf_betabin$prob,
  dist_params = rr$coefficients,
  distribution = "weibull3"
)

plot_conf_beta <- plot_conf(
  p_obj = plot_reg_weibull,
  x = list(conf_betabin$x),
  y = list(conf_betabin$lower_bound, conf_betabin$upper_bound),
  direction = "y",
  distribution = "weibull3"
)

# Example 2 - Probability Plot, Regression Line and Confidence Bounds for Three-Parameter-Lognormal:
rr_ln <- rank_regression(
  x = prob_tbl$x,
  y = prob_tbl$prob,
  status = prob_tbl$status,
  distribution = "lognormal3"
)

conf_betabin_ln <- confint_betabinom(
  x = prob_tbl$x,
  status = prob_tbl$status,
  dist_params = rr_ln$coefficients,
  distribution = "lognormal3"
)

plot_lognormal <- plot_prob(
  x = prob_tbl$x,
  y = prob_tbl$prob,
  status = prob_tbl$status,
  id = prob_tbl$id,
  distribution = "lognormal"
)

plot_reg_lognormal <- plot_mod(
  p_obj = plot_lognormal,
  x = conf_betabin_ln$x,
  y = conf_betabin_ln$prob,
  dist_params = rr_ln$coefficients,
  distribution = "lognormal3"
)

plot_conf_beta_ln <- plot_conf(
  p_obj = plot_reg_lognormal,
  x = list(conf_betabin_ln$x),
  y = list(conf_betabin_ln$lower_bound, conf_betabin_ln$upper_bound),
  direction = "y",
  distribution = "lognormal3"
)

}
\references{
Meeker, William Q; Escobar, Luis A., Statistical methods for
reliability data, New York: Wiley series in probability and statistics, 1998
}
\seealso{
\link{plot_conf}
}
