% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whapi_clip_text}
\alias{whapi_clip_text}
\title{Clip long text with ellipsis}
\usage{
whapi_clip_text(x, width = 420, ellipsis = "...")
}
\arguments{
\item{x}{Character string to clip.}

\item{width}{Maximum length of the output including ellipsis.}

\item{ellipsis}{Character to indicate truncation.}
}
\value{
A clipped string with ellipsis if needed.
}
\description{
Shortens text to a maximum width (character length). If the text is longer,
it is truncated and an ellipsis (default \code{"..."}) is appended.
}
\examples{
whapi_clip_text("This is a very long sentence that should be clipped.", width = 20)
#> "This is a very long..."
}
