% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whapi_send_image}
\alias{whapi_send_image}
\title{Send an image via Whapi.Cloud (file, url, or base64)}
\usage{
whapi_send_image(
  to,
  image,
  type = c("file", "url", "base64"),
  caption = NULL,
  token = Sys.getenv("WHAPI_TOKEN", unset = ""),
  timeout = 30,
  verbose = TRUE
)
}
\arguments{
\item{to}{Character(1). WhatsApp target (E.164 digits only, no "+") or chat id.}

\item{image}{Character(1). File path (for \code{type="file"}), URL (\code{type="url"}),
or data URI (\code{type="base64"}).}

\item{type}{One of \code{c("file","url","base64")}. Default = \code{"file"}.}

\item{caption}{Optional caption text.}

\item{token}{Bearer token (defaults to env var \code{WHAPI_TOKEN} if not given).}

\item{timeout}{Numeric. Timeout in seconds. Default \code{30}.}

\item{verbose}{Logical. Show CLI messages? Default \code{TRUE}.}
}
\value{
A tibble with \code{id}, \code{to}, \code{status}, \code{timestamp}, \code{timestamp_dt}, and raw \code{resp}.
}
\description{
Sends an image using Whapi's \code{POST /messages/image}.
Supports three input modes through \code{type}:
\itemize{
\item \code{"file"}: local path -> reads bytes and builds a \verb{data:<mime>;name=<file>;base64,<...>} URI
\item \code{"url"}: direct \code{http(s)} URL
\item \code{"base64"}: pre-built data URI (\verb{data:image/...;base64,...})
}
}
\examples{
\dontrun{
# Sys.setenv(WHAPI_TOKEN = "your_token_here")
 whapi_send_image("5581999999999", image = "card.png", type = "file", caption = "Card")
 whapi_send_image("5581999999999", image = "https://site.com/img.png", type = "url")
 b64 <- openssl::base64_encode(readBin("card.png","raw",file.info("card.png")$size))
 data_uri <- sprintf("data:image/png;name=\%s;base64,\%s", basename("card.png"), b64)
 whapi_send_image("5581999999999", image = data_uri, type = "base64")
}
}
