% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mab_inference.R
\name{adaptive_aipw}
\alias{adaptive_aipw}
\title{Calculate Adaptive AIPW Estimates}
\usage{
adaptive_aipw(data, assignment_probs, conditions, periods, verbose)
}
\arguments{
\item{data}{A data.frame, data.table, or tibble containing input data from the trial. This should be the results
of a traditional Randomized Controlled Trial (RCT). Any data.frames will be converted to tibbles internally.}

\item{assignment_probs}{A tibble/data.table containing the probabilities of being
assigned each treatment at a given period.}

\item{periods}{Numeric value of length 1; number of total periods in the simulation.}

\item{verbose}{Logical; whether or not to print intermediate messages. Default is FALSE.}
}
\value{
A tibble/data.table containing the AIPW estimate of treatment success, AIPW variance,
sample proportion of successful treatments (sample mean), and sample mean variance.
}
\description{
Averages the observation level AIPW scores created by \code{\link[=get_iaipw]{get_iaipw()}} across each period, then assigns
each estimate an adaptive weight based on \href{https://www.pnas.org/doi/full/10.1073/pnas.2014602118}{Hadad et. al (2021)}, and
another weight based on the size of each period to calculate the final AIPW estimate and variance for each treatment.
Sample means and variances are also provided for comparison.
}
\details{
The formulas for the calculations in this function can be found in
\href{https://www.pnas.org/doi/full/10.1073/pnas.2014602118}{Hadad et al. (2021)} at
equation 5 (estimate), equation 11 (variance), equation 15 (allocation rate).

The formulas specified assume that each period is 1 observation but in the cases
for this simulation where periods contain multiple observations the individual estimates
from each period are averaged and weighted by size before being used in the final calculations.

The AIPW estimator is unbiased, consistent, and asymptotically normal under the conditions of the simulated trial
of the so can be used for valid inference with a normal distribution. The sample means and variances
are provided for comparison but these are biased and inconsistent under the conditions of the simulated trial
}
\references{
Hadad, Vitor, David A. Hirshberg, Ruohan Zhan, Stefan Wager, and Susan Athey. 2021.
"Confidence Intervals for Policy Evaluation in Adaptive Experiments." \emph{Proceedings of the National Academy of Sciences of the United States of America} 118
(15): e2014602118. \doi{10.1073/pnas.2014602118}.
}
\keyword{internal}
