% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_validation.R
\name{check_cols}
\alias{check_cols}
\title{Checking existence and declaration of columns}
\usage{
check_cols(
  assignment_method,
  time_unit,
  perfect_assignment,
  data_cols,
  data,
  verbose
)
}
\arguments{
\item{assignment_method}{A character string; one of "date", "batch", or "individual", to define the assignment into treatment waves. When using
"batch" or "individual", ensure your dataset is pre-arranged in the proper order observations should be considered so that
groups are assigned correctly. For "date", observations will be considered in chronological order.
"individual" assignment can be computationally intensive for larger datasets.}

\item{time_unit}{A character string specifying the unit of time for assigning periods when \code{assignment_method} is "date".
Acceptable values are "day", "week", or "month". "month" does not require an additional column with the months of each observation,
but it can accept a separate \code{month_col}. If \code{month_col} is specified, the periods follow the calendar months strictly, and when it is not
specified months are simply used as the time interval. For example if a dataset has dates starting on July 26th, under month based assignment and
a specified \code{month_col} the dates July 26th and August 3st would be in different periods, but if the \code{month_col} was not specified, they would be
in the same period because the dates are less than one month apart.}

\item{perfect_assignment}{Logical; if TRUE, assumes perfect information for treatment assignment
(i.e., all outcomes are observed regardless of the date).
If FALSE, hides outcomes not yet theoretically observed, based
on the dates treatments would have been assigned for each wave.
This is useful when simulating batch-based assignment where treatments were assigned
on a given day whether or not all the information from a prior batch was available and
you have exact dates treatments were assigned.}

\item{data_cols}{A named character vector containing the names of columns in \code{data} as strings:
\itemize{
\item \code{id_col}: Column in \code{data}; contains unique ID as a key.
\item \code{success_col}: Column in \code{data}; binary successes from the original experiment.
\item \code{condition_col}: Column in \code{data}; original treatment condition for each observation.
\item \code{date_col}: Column in \code{data}; contains original date of event/trial. Only necessary when assigning by "Date". Must be of type \code{Date}, not a character string.
\item \code{month_col}: Column in \code{data}; contains month of treatment. Only necessary when \code{time_unit = "Month"}, and when periods should be determined directly by
the calendar months instead of month based time periods. This column can be a string/factor variable with the month names or numeric with the month number. It can easily
be created from your \code{date_col} via \code{lubridate::month(data[[date_col]])} or \code{format(data[[date_col]], "\%m")}.
\item \code{success_date_col}: Column in \code{data}; contains original dates each success occurred. Only necessary when \code{perfect_assignment = FALSE}. Must be of type \code{Date}, not a character string.
\item \code{assignment_date_col}: Column in \code{data}; contains original dates treatments were assigned to observations. Only necessary when \code{perfect_assignment = FALSE}.
Used to simulate imperfect information on the part of researchers conducting an adaptive trial. Must be of type \code{Date}, not a character string.
}}

\item{data}{A data.frame, data.table, or tibble containing input data from the trial. This should be the results
of a traditional Randomized Controlled Trial (RCT). Any data.frames will be converted to tibbles internally.}

\item{verbose}{Logical; whether or not to print intermediate messages. Default is FALSE.}
}
\value{
Throws an error if columns which are required have not been declared
or are not present in the data, or are the wrong primitive data type. Additionally throws warning messages,
if unnecessary columns have been provided, only when \code{verbose} is TRUE.
}
\description{
Helper to \code{\link[=validate_inputs]{validate_inputs()}}. This function accepts the user's
settings for the Multi-Arm-Bandit trial, and checks whether columns in the data have been properly
specified based on these settings.
}
\keyword{internal}
