% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_mab_simulation.R
\name{cols}
\alias{cols}
\title{Column arguments shared across functions}
\arguments{
\item{id_col}{Column in \code{data}; contains unique ID as a key.}

\item{success_col}{Column in \code{data}; binary successes from the original experiment.}

\item{condition_col}{Column in \code{data}; original treatment condition for each observation.}

\item{date_col}{Column in \code{data}; contains original date of event/trial. Only necessary when assigning by "Date". Must be of type \code{Date}, not a character string.}

\item{month_col}{Column in \code{data}; contains month of treatment. Only necessary when \code{time_unit = "Month"}, and when periods should be determined directly by
the calendar months instead of month based time periods. This column can be a string/factor variable with the month names or numeric with the month number. It can easily
be created from your \code{date_col} via \code{lubridate::month(data[[date_col]])} or \code{format(data[[date_col]], "\%m")}.}

\item{success_date_col}{Column in \code{data}; contains original dates each success occurred. Only necessary when \code{perfect_assignment = FALSE}. Must be of type \code{Date}, not a character string.}

\item{assignment_date_col}{Column in \code{data}; contains original dates treatments were assigned to observations. Only necessary when \code{perfect_assignment = FALSE}.
Used to simulate imperfect information on the part of researchers conducting an adaptive trial. Must be of type \code{Date}, not a character string.}
}
\description{
Topic holding common arguments across many functions. Used to expedite documentation, through
\code{inheritParams} tag from roxygen2.
}
\keyword{internal}
