% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.best.window.R
\name{map.best.window}
\alias{map.best.window}
\title{Plots spectra highlighting windows with the best performance.}
\usage{
map.best.window(
  wpls = NULL,
  fade = 0.7,
  col.window = "steelblue",
  xlab = "Wavelengths",
  ylab = "Absorbance",
  title = NULL,
  legend = NULL
)
}
\arguments{
\item{wpls, }{object obtained from \strong{cv.wpls}.}

\item{fade, }{opacity of the window.}

\item{col.window, }{color of the window that highlights the region.}

\item{xlab, }{title of the x axis.}

\item{ylab}{title of the y axis.}

\item{title, }{title of the plot.}

\item{legend, }{description description}
}
\value{
Plot of the spectra with a window that highlights the region with the lowest cross-validation error.
}
\description{
Plots spectra highlighting windows with the best performance.
}
\examples{
data(beer)
conc=beer[,1]
sp=beer[,2:ncol(beer)]
names(sp)=convert.names.wl(1100,2250,2)
conc=unlist(conc)
mywpls=cv.wpls(sp, conc,mode='wpls', windows = 5)
map.best.window(mywpls)
}
