% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmse.single.window.R
\name{rmse.single.window}
\alias{rmse.single.window}
\title{Plots RMSE of calibration and cross-validation of a single wnindow.}
\usage{
rmse.single.window(
  wpls = NULL,
  condition = "Complete",
  shape.cal = 19,
  shape.cv = 19,
  width = 1,
  size = 2,
  col.cal = "blue",
  col.cv = "red",
  xaxis.title = "Component",
  yaxis.title = "RMSE",
  title = paste("Plot of RMSE for the", condition, "model"),
  legend.name = NULL,
  x.legend = 0.1,
  y.legend = 0.2
)
}
\arguments{
\item{wpls, }{object obtained from \strong{cv.wpls}.}

\item{condition, }{name of the Window the user wants to plot.}

\item{shape.cal, }{shape of the point of the calibration line.}

\item{shape.cv, }{shape of the point of the cross-validation line.}

\item{width, }{width of the line.}

\item{size, }{size of the points of calibration and cross-validation.}

\item{col.cal, }{color for the calibration line.}

\item{col.cv, }{color for the cross-validation line.}

\item{xaxis.title, }{title of the x axis.}

\item{yaxis.title, }{title of the y axis.}

\item{title, }{title of the plot.}

\item{legend.name, }{displays legend and its name.}

\item{x.legend, }{position of the legend on the x axis, ranges from 0 to 1.}

\item{y.legend, }{position of the legend on the y axis, ranges from 0 to 1.}
}
\value{
Plot of RMSE of the region requested by the user.
}
\description{
Plots RMSE of calibration and cross-validation of a single wnindow.
}
\examples{
data(beer)
conc=unlist(beer[,1])
sp=beer[,2:ncol(beer)]
names(sp)=convert.names.wl(1100,2250,2)
mywpls=cv.wpls(sp, conc,mode='wpls', windows = 5)
rmse.single.window(mywpls,'Window2')
}
