% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_gd.R
\name{plot_gd}
\alias{plot_gd}
\title{Plot moving window map of genetic diversity}
\usage{
plot_gd(
  x,
  bkg = NULL,
  index = NULL,
  col = viridis::magma(breaks),
  breaks = 100,
  main = NULL,
  box = FALSE,
  range = NULL,
  legend = TRUE,
  ...
)
}
\arguments{
\item{x}{Output from \link[wingen]{window_gd} or \link[wingen]{krig_gd} (SpatRaster where first layer is genetic diversity).}

\item{bkg}{Optional SpatRaster or other spatial object that will be plotted as the "background" in gray.}

\item{index}{If a raster stack is provided, index of the layer to plot (defaults to plotting all layers except layers named "sample_count").}

\item{col}{Color palette to use for plotting (defaults to \link[viridis]{magma} palette).}

\item{breaks}{Number of breaks to use in color scale (defaults to 100).}

\item{main}{character. Main plot titles (one for each layer to be plotted). You can use arguments \code{cex.main}, \code{font.main}, \code{col.main} to change the appearance; and \code{loc.main} to change the location of the main title (either two coordinates, or a character value such as "topleft"). You can also use \code{sub=""} for a subtitle. See \code{\link{title}}}

\item{box}{Whether to include a box around the Raster plot (defaults to FALSE).}

\item{range}{Numeric. minimum and maximum values to be used for the continuous legend.}

\item{legend}{Whether to include legend.}

\item{...}{arguments passed to \code{plot("SpatRaster", "numeric")} and additional graphical arguments}
}
\value{
plot of genetic diversity
}
\description{
Plot genetic diversity layer produced by \link[wingen]{window_gd} or \link[wingen]{krig_gd}
}
\examples{
data("mini_lyr")
plot_gd(mini_lyr)

}
