% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fb_team_goal_logs.R
\name{fb_team_goal_logs}
\alias{fb_team_goal_logs}
\title{Get team goal logs}
\usage{
fb_team_goal_logs(team_urls, time_pause = 3, for_or_against = "for")
}
\arguments{
\item{team_urls}{the URL(s) of the team(s) (can come from fb_teams_urls())}

\item{time_pause}{the wait time (in seconds) between page loads}

\item{for_or_against}{select whether to return data of goals "for" (the default), goals "against", or "both"}
}
\value{
returns a dataframe of the team's goals scored and conceded in the season
}
\description{
Returns the team's season goal logs
}
\examples{
\dontrun{
try({
# for single teams:
man_city_url <- "https://fbref.com/en/squads/b8fd03ef/Manchester-City-Stats"
fb_team_goal_logs(team_urls = man_city_url, for_or_against = "for")
})
}
}
