% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeFragments.R
\name{.exNamesTyDeList}
\alias{.exNamesTyDeList}
\title{Reorganize List Of Peptide Fragments To Matrix}
\usage{
.exNamesTyDeList(
  x,
  subLiNames = c("full", "Nter", "Cter", "inter"),
  inclNo = TRUE,
  fullSeq = NULL,
  outCol = c("seq", "orig", "origNa", "ty", "seqNa", "beg", "end", "precAA", "tailAA",
    "ambig", "mass"),
  silent = FALSE,
  callFrom = NULL,
  debug = FALSE
)
}
\arguments{
\item{x}{(list) list of lists with charcter vectors of sequences with names that can be parsed eg 'x.1-7' to extract 'beg'&'end' otherwise ALL output will be NA (+message form extractLast2numericParts())}

\item{subLiNames}{(character)}

\item{inclNo}{(logical) add 1st col with number}

\item{fullSeq}{(character) to reinject full sequence which may not be used in names of 'x' and not be in x[[1]][["full"]]}

\item{outCol}{(character) columns to create in output}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}

\item{debug}{(logical) for bug-tracking: more/enhanced messages}
}
\value{
This function returns matrix with fragment sequence, mass, start- and end-position, heading and tailing AA (or NA if terminal fragment)
}
\description{
This function allows reorganiziong a list (of lists) of peotide fragments into matrix
}
\examples{
prot1 <- c(protP="KEPTIDE", pro2="MPRATE")
## fragment all target proteins
pep3 <- lapply(prot1, fragmentSeq, minSize=3, maxSize=5, internFragments=FALSE, 
  separTerm=TRUE, keepRedSeqs=TRUE)
pepTab <- .exNamesTyDeList(pep3, fullSeq=prot1) 
}
\seealso{
\code{\link{makeFragments}};  \code{\link{evalIsoFragm}}, from package \href{https://CRAN.R-project.org/package=wrProteo}{wrProteo} \code{\link[wrProteo]{convAASeq2mass}}, \code{\link[wrProteo]{AAmass}}, \code{\link[wrProteo]{massDeFormula}}
}
