% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ci_eta3_robust}
\alias{ci_eta3_robust}
\title{Generate eta3 robust confidence interval}
\usage{
ci_eta3_robust(wv_robust, wv_ci_class, alpha_ov_2, eff)
}
\arguments{
\item{wv_robust}{A \code{vec} that computes the modwt dot product of each wavelet coefficient divided by their length.}

\item{wv_ci_class}{A \code{mat} that contains the CI mean, CI Lower, and CI Upper}

\item{alpha_ov_2}{A \code{double} that indicates the \eqn{\left(1-p\right)*\alpha}{(1-p)*alpha} confidence level}

\item{eff}{A \code{double} that indicates the efficiency.}
}
\value{
A \code{matrix} with the following columns:
 \item{Column 1}{Robust Wavelet Variance}
 \item{Column 2}{Chi-squared Lower Bounds}
 \item{Column 3}{Chi-squared Upper Bounds}
}
\description{
Computes the eta3 robust CI
}
\details{
Within this function we are scaling the classical
}
\keyword{internal}
