% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BNFhelpers.R
\name{findNextRuleForExpansion}
\alias{findNextRuleForExpansion}
\title{Find next rule which must be expanded.}
\usage{
findNextRuleForExpansion(PT, fNTS, G)
}
\arguments{
\item{PT}{Production table.}

\item{fNTS}{List of finite non terminals.}

\item{G}{A grammar.}
}
\value{
A list of indices.
}
\description{
Find next rule which must be expanded.
}
\examples{
g<-compileBNF(booleanGrammar())
finiteRules<-finiteRulesOfG(g)
SPT<-newPT(LHS=g$PT$LHS[finiteRules], RHS=g$PT$RHS[finiteRules])
finiteNTs<-unique(SPT$LHS)
rest<-!(finiteRulesOfG(g) | directRecursion(g))
restPT<-newPT(LHS=g$PT$LHS[rest], RHS=g$PT$RHS[rest])
findNextRuleForExpansion(restPT, finiteNTs, g)

}
\seealso{
Other Compilation of short production table: 
\code{\link{allTerminal}()},
\code{\link{cL}()},
\code{\link{directRecursion}()},
\code{\link{expandGrid}()},
\code{\link{expandRules}()},
\code{\link{finiteRulesOfG}()},
\code{\link{nonTerminalsOfG}()},
\code{\link{smallestRules}()}
}
\concept{Compilation of short production table}
