% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivationTrees.R
\name{filterANL}
\alias{filterANL}
\title{Filter an Attributed Node List (ANL) of a derivation tree by depth.}
\usage{
filterANL(ANL, minb = 1, maxb = 3)
}
\arguments{
\item{ANL}{Attributed node list.}

\item{minb}{Integer.}

\item{maxb}{Integer.}
}
\value{
An attributed node list with nodes whose depths are in 
        \code{minb:maxb}. 
          Each node is represented as a list of the following attributes:
        \itemize{
        \item \code{Node$ID}:  Id in the symbol table ST.
        \item \code{Node$NonTerminal}:  Is the symbol a non-terminal?
        \item \code{Node$Pos}: Position in the trail.
        \item \code{Node$Depth}:  Depth of node.
        \item \code{Node$Rdepth}: Residual depth for expansion.
        \item \code{Node$subtreedepth}: Depth of subtree starting here.
        \item \code{Node$Index}:  R index of the node in the derivation tree.
                           Allows fast tree extraction and insertion.
        }
}
\description{
\code{filterANL()} deletes all nodes whose depth 
             \code{node$Depth}  is 
             less than \code{minb} and larger than \code{maxb}
             from the ANL. 
             However, if the resulting list is empty, the original
             ANL is returned.
}
\details{
An attributed \code{node} has the following elements:
    \itemize{
        \item \code{$ID}:  Id in the symbol table \code{ST}.
        \item \code{$NonTerminal}:  Is the symbol a non-terminal?
        \item \code{$Pos}: Position in the trail.
        \item \code{$Depth}:  Depth of node.
        \item \code{$Rdepth}: Residual depth for expansion.
        \item \code{$subtreedepth}: Depth of subtree starting here.
        \item \code{$Index}:  R index of the node in the derivation tree.
                           Allows fast tree extraction and insertion.
       }
}
\examples{
g<-compileBNF(booleanGrammar())
set.seed(111)
a<-randomDerivationTree(g$Start, g, maxdepth=10)
b<-treeANL(a, g$ST)
c<-filterANL(b, minb=1, maxb=3)
d<-filterANL(b, minb=3, maxb=5)
e<-filterANL(b, minb=14, maxb=15)
f<-filterANL(b, minb=13, maxb=15)

}
\seealso{
Other Access Tree Parts: 
\code{\link{filterANLid}()},
\code{\link{treeANL}()},
\code{\link{treeChildren}()},
\code{\link{treeRoot}()}
}
\concept{Access Tree Parts}
