% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaDfCrossover.R
\name{xegaDfCrossGene}
\alias{xegaDfCrossGene}
\title{One point crossover of 2 genes.}
\usage{
xegaDfCrossGene(gg1, gg2, lF)
}
\arguments{
\item{gg1}{Real-coded gene.}

\item{gg2}{Real-coded gene.}

\item{lF}{Local configuration of the genetic algorithm.}
}
\value{
Real-coded gene.
}
\description{
\code{xegaDfCrossGene()} randomly determines a cut point.
    It combines the parameters before the cut point of the first gene
    with the parameters after the cut point from the second gene (kid 1).
}
\examples{
gene1<-xegaDfInitGene(lFxegaDfGene)
gene2<-xegaDfInitGene(lFxegaDfGene)
gene3<-xegaDfCrossGene(gene1, gene2, lFxegaDfGene)
}
\seealso{
Other Crossover (Returns 1 Kid): 
\code{\link{xegaDfUCrossGene}()},
\code{\link{xegaDfUPCrossGene}()}
}
\concept{Crossover (Returns 1 Kid)}
